function f = righttruncnorm(mu,std,upper)
% RIGHTTRUNCNORM returns a sample vector of normal deviates with means mu
% standard deviation std, truncated to the right (upper)
%
% Calculate bounds on probabilities

  upperProb = normalcdf((upper-mu)./std);

% Draw uniform from within (lowerProb,upperProb)
  u = upperProb.*rand(size(mu));

% Find needed quantiles
  f = mu + normalinv(u).*std;
  
% Manuela Zucknick, 15-04-2005
