function f = righttrunclogis(mu,std,upper)
% RIGHTTRUNCLOGIS returns a sample vector of logistic deviates with means 
% mu, standard deviation std, truncated to the right (upper)

% Calculate bounds on probabilities
  upperProb = logt_cdf((upper-mu)./std);

% Draw uniform from within (lowerProb,upperProb)
  u = upperProb.*rand(size(mu));

% Find needed quantiles
  f = mu + logt_inv(u).*std;
  
% Manuela Zucknick, 15-04-2005
