function f = normrt(mu,std,upper)
% NORMRT returns a single number, sampled from a normal distribution 
% with means mu standard deviation std, truncated to the right (upper), 
% using the accept-reject algorithm by Robert (1995) 
% (which is guaranteed to be more efficient than the classical cdf 
% inversion technique if mu < upper).
% 
% Reference:
% Robert C.P. Simulation of truncated normal variables. Statistics 
% and Computing (1995) 5, 121-125  

%use algorithm for left-truncated normal:
f = -normlt(-mu,std,-upper);

% Manuela Zucknick, 11-05-2005