function f = normlt(mu,std,lower)
% NORMLT returns a single number, sampled from a normal distribution 
% with means mu standard deviation std, truncated to the left (lower), 
% using the efficient accept-reject algorithm by Robert (1995).
% The algorithm is optimal if mu < lower.
% 
% Reference:
% Robert C.P. Simulation of truncated normal variables. Statistics 
% and Computing (1995) 5, 121-125  

mulow = (lower - mu)/std;

% if mulow is very small, just draw from regular standard normal
% distribution (value would almost never be accepted in algorithm below):
if mulow < -100
    f = randn;
    
else
    % if mulow very large, just set f = Z = mulow
    % (since: mulow->Inf => (acceptance probability->1 and Z->mulow))
    if mulow > 10000    %to avoid overflow
        f = mulow;
        
    else
        % draw from a left-truncated standard normal distribution:
        alpha = (mulow + sqrt(mulow^2 + 4))/2;
        OK = 0;
        while ~OK
            U = rand;
            Z = -(1/alpha)*log(U) + mulow;   %Z~Exp(alpha,lower) [inversion method]
            rho = exp(-(Z-alpha)^2/2);
            U = rand;
            if U <= rho
                f = Z;
                OK = 1;
            end
        end
    end
end

f = (f + mu)*std;    

% Manuela Zucknick, 11-05-2005