function f = lefttrunclogis(mu,std,lower)
% LEFTTRUNCLOGIS returns a sample vector of normal deviates with means mu
% standard deviation std, truncated to the left (lower)

% Calculate bounds on probabilities
  lowerProb = logt_cdf((lower-mu)./std);
  upperProb = 1;

% Draw uniform from within (lowerProb,upperProb)
  u = lowerProb+(upperProb-lowerProb).*rand(size(mu));
  
% Find needed quantiles
  f = mu + logt_inv(u).*std;

% Manuela Zucknick, 15-04-2005


