function LAM = lambdadist(r)
% LAMBDADIST Sampling from full conditional distribution of LAM
% in Bayesian auxiliary variable model for logistic regression
% using joint update to {z,beta}
% Based on pseudocode A4 by Chris Holmes and Leonhard Held (2006)
%
% Reference: 
% Holmes, C. and Held, L. (2006). "Bayesian Auxiliary Variable Models for 
% Binary and Multinomial Regression", Bayesian Analysis 1:145-168

OK = 0;
while ~OK
   Y = randn;
   if Y ~= 0
   Y = Y^2;
   Y = 1 + (Y - sqrt(Y*(4*r + Y)))/(2*r);
   if Y ~= 0
       U = rand;
       if U <= 1/(1 + Y)
           LAM = r/Y;
       else
           LAM = r*Y;
       end
       %% Now LAM ~ GIG(0.5, 1, r^2) = rejection sampling distribution
   
       U = rand;
       if LAM > 4/3
           OK = local_right(U,LAM);
       else
           OK = local_left(U,LAM);
       end
   end
   end
end

function OK = local_right(U,LAM)
% LOCAL_RIGHT Help function for function LAMBDADIST 
Z = 1;
X = exp(-0.5*LAM);
j = 0;
STOP = 0;
while ~STOP
    j = j + 1;
    j2 = (j + 1)^2;
    Z = Z - j2 * X^(j2 - 1);
    if Z > U
        STOP = 1;
        OK = 1;
        break
    end
    j = j + 1;
    j2 = (j + 1)^2;
    Z = Z + j2 * X^(j2 - 1);
    if Z < U
        STOP = 1;
        OK = 0;
        break
    end
end

function OK = local_left(U,LAM)
% LOCAL_LEFT Help function for function LAMBDADIST 
H = 0.5*log(2) + 2.5*log(pi) - 2.5*log(LAM) - pi^2/(2*LAM) + 0.5*LAM;
lU = log(U);
Z = 1;
X = exp(-pi^2/(2*LAM));
K = LAM/pi^2;
j = 0;
STOP = 0;
while ~STOP
    j = j + 1;
    Z = Z - K*X^(j^2 - 1);
    if (H + log(Z) > lU)
        STOP = 1;
        OK = 1;
        break
    end
    j = j + 1;
    j2 = (j + 1)^2;
    Z = Z + j2 * X^(j2 - 1);
    if (H + log(Z) < lU)
        STOP = 1;
        OK = 0;
        break
    end
end

% Manuela Zucknick, 09-08-2006