function [beta,GAM,alpha,logprior,logpost] = ...
    betaGAM_update_simple(LAM,Z,X,v,PI,GAM,temp)
% BETAGAM_UPDATE_SIMPLE add/delete Metropolis-Hastings update for LAM and Z 
% in Bayesian auxiliary variable model for logistic regression with variable 
% selection
% Help function for LOGISTICVS
%
% Selects a variable at random and attempts to update it by proposing to
% change the value from 0 to 1 or from 1 to 0, respectively

if (nargin < 7)
    temp = 1;
end

n = size(X,1);
p = size(X,2);

%here, temperature temp only comes in as a multiplier for LAM in the 
%(tempered) density p(Z|LAM,beta,Xgam)* = N(Xgam*beta, LAM*temp):
LAM = LAM*temp; 
invLAM = diag(1./diag(LAM));

%(0) compute values corresponding to current GAM
Xgam = X(:,logical(GAM));
vgam = v(logical(GAM),logical(GAM));
if sum(GAM) > n
    %inversion of nxn matrix:
    Vgam = vgam - vgam*Xgam'*inv(LAM + Xgam*vgam*Xgam')*Xgam*vgam;
else
    %inversion of dxd matrix (d=dim(GAM)):
    Vgam = inv(Xgam'*invLAM*Xgam + inv(vgam));  
end
Bgam = Vgam*Xgam'*invLAM*Z;

%(1) proposal for GAM
%    (select covariate randomly and change GAM_i from 0 to 1 or 1 to 0)
GAMstar = GAM;
select = randperm(p);
select = select(1);
if GAM(select,1) == 0
    GAMstar(select,1) = 1;
    priorratio = PI(select)/(1-PI(select)); %prior(GAMstar)/prior(GAM)
else
    GAMstar(select,1) = 0;
    priorratio = (1-PI(select))/PI(select);
end

%(2) compute values corresponding to proposed GAMstar
Xstar = X(:,logical(GAMstar));
vstar = v(logical(GAMstar),logical(GAMstar));
if sum(GAMstar) > n
    %inversion of nxn matrix:
    Vstar = vstar - vstar*Xstar'*inv(LAM + Xstar*vstar*Xstar')*Xstar*vstar;
else
    %inversion of dxd matrix (d=dim(GAM)):
    Vstar = inv(Xstar'*invLAM*Xstar + inv(vstar));  
end
Bstar = Vstar*Xstar'*invLAM*Z;
    
%(3) acceptance/rejection step
detVratio = sqrt(det(Vstar)/det(Vgam));
expBratio = exp(0.5*Bstar'*inv(Vstar)*Bstar - 0.5*Bgam'*inv(Vgam)*Bgam);
detvratio = sqrt(det(vgam)/det(vstar));
alpha = min(1, priorratio*detVratio*expBratio*detvratio);
U = rand;
if U < alpha
    GAM = GAMstar;
    Vgam = Vstar;
    Bgam = Bstar;
    Xgam = Xstar;
    vgam = vstar;
end
Zprec = invLAM - invLAM*Xgam*Vgam*Xgam'*invLAM;
logPgam = normpdfln(Z, zeros(size(Z)), 'inv', Zprec);

T = randn(sum(GAM),1);
L = chol(Vgam)';   %lower triangular Cholesky factorisation matrix
beta = Bgam + L*T;

% log probabilities log(P(beta,GAM|Z,LAM)) and log(P(beta,GAM))
logpriorGAM = sum(log(PI).*GAM + log(1-PI).*(1-GAM));
%logpostGAM = logPgam + logpriorGAM;
if numel(beta) > 0
    logpostbeta = normpdfln(beta, Bgam, [], Vgam);
    logpriorbeta = normpdfln(beta, zeros(size(beta)), [], vgam);
else
    logpostbeta = 0;    %P(beta=empty|GAM,Z,LAM) = 1 (since GAM=zeros(p))
    logpriorbeta = 0;
end
logprior = logpriorGAM + logpriorbeta;
%logpost = logpostGAM + logpostbeta;
logpost = logPgam + logpostbeta;    %logpriorGAM cancels out anyway

% Manuela Zucknick, last update: 02-03-07