function [beta,GAM,numneigh,logprior,logpost] = ...
    betaGAM_update_blockSingleGibbs(LAM,Z,X,v,PI,GAM,block,K2,K1,temp)
% BETAGAM_UPDATE_BLOCKSINGLEGIBBS sngle Gibbs update for LAM and Z in Bayesian 
% auxiliary variable model for logistic regression with variable selection
% Help function for LOGISTICVS
%
% Selects a variable at random and updates it plus up to (K1-1) neighbours
% together from their single conditional distributions

if (K1 > 0 & K2 > 0)
    error('K1 and K2 cannot both be greater than zero at the same time.\n Please set one of these parameter to zero or negative to disactivate this option.');
end

if (nargin < 10)
    temp = 1;
end

n = size(X,1);
p = size(X,2);

%here, temperature temp only comes in as a multiplier for LAM in the 
%(tempered) density p(Z|LAM,beta,Xgam)* = N(Xgam*beta, LAM*temp):
LAM = LAM*temp; 
invLAM = diag(1./diag(LAM));

%(0) compute values corresponding to current GAM
Xgam = X(:,logical(GAM));
vgam = v(logical(GAM),logical(GAM));
if sum(GAM) > n
    %inversion of nxn matrix:
    Vgam = vgam - vgam*Xgam'*inv(LAM + Xgam*vgam*Xgam')*Xgam*vgam;
else
    %inversion of dxd matrix (d=dim(GAM)):
    Vgam = inv(Xgam'*invLAM*Xgam + inv(vgam));  
end
Bgam = Vgam*Xgam'*invLAM*Z;

%(1) proposal for GAM
%    (select gamma_i at random, find 'mates' and for all of these,
%     draw from p(GAM_i|Z) [Lee et al. (2003)]: draw by computing density
%     for both possible values (1 and 0). One value is available from 
%     GAMstar in previous iteration, only compute the other one = GAMtry)
Zprecgam = invLAM - invLAM*Xgam*Vgam*Xgam'*invLAM;
detZprecgam = det(Zprecgam);
Pgam = sqrt(detZprecgam)*exp(-0.5*(Z'*Zprecgam*Z)); %p(Z|GAM)=MVN(0,inv(Zprec))

%find variables to update together with GAM(select) (= block)
if(strcmpi(block,'all'))
    neighbour = 1:p;
elseif(numel(block)==1)
    select = randperm(p);
    neighbour = select(1:block);   %select 'block' variables at random
    numneigh = block;
else
    select = randperm(p);
    select = select(1);
    neighbour = find(block(select,:));   %1st order nb.
    if (K1 > 0)
        %select up to (K1-1) first-order neighbours of select
        numneigh = numel(neighbour);
        selectneigh = randperm(numneigh);
        selectneigh = neighbour(selectneigh);
        maxneigh = min((K1-1), numneigh);
        neighbour = selectneigh(1:maxneigh);
    end
    neighbour = unique([select, neighbour]);
    numneigh = numel(neighbour);    % = K1 or smaller if K1 > 0

    if (K2 > 0)
        neighbour2 = 0;
        for k = 1:numel(neighbour)  %1st order nb of neighbour1 = 2nd order nb
            neighbour2 = [neighbour2, find(block(neighbour(1,k),:))];
        end
        neighbour2 = neighbour2(2:numel(neighbour2));   %remove 0
        neighbour2 = unique(neighbour2);

        %%select K2 genes for updating among all second-order neighbours
        numneigh = numel(neighbour2);
        selectneigh = randperm(numneigh);
        selectneigh = neighbour2(selectneigh);
        K2 = min(K2, numneigh);
        selectneigh = selectneigh(1:K2);  
        neighbour = unique([neighbour, selectneigh]);
    end
end

numneigh = numel(neighbour);
GAMstar = GAM;
Pstar = Pgam;
for index = 1:numneigh
    i = neighbour(index);
    
    %in each iteration compare GAMtry to currently accepted gamma:
    GAMtry = GAMstar;
    if GAMstar(i) == 0
        GAMtry(i) = 1;
    else
        GAMtry(i) = 0;
    end
    
    Xtry = X(:,logical(GAMtry));
    vtry = v(logical(GAMtry),logical(GAMtry));
    if sum(GAMtry) > n
        %inversion of nxn matrix:
        Vtry = vtry - vtry*Xtry'*inv(LAM + Xtry*vtry*Xtry')*Xtry*vtry;
    else
        %inversion of dxd matrix (d=dim(GAMtry)):
        Vtry = inv(Xtry'*invLAM*Xtry + inv(vtry));  
    end
    Zprectry = invLAM - invLAM*Xtry*Vtry*Xtry'*invLAM;
    detZprectry = det(Zprectry);
    Ptry = sqrt(detZprectry)*exp(-0.5*(Z'*Zprectry*Z)); %p(Z|GAM)=MVN(0,inv(Zprec))
    
    %only multiply by p(GAM(i)) because all the rest cancels out anyway
    probTRY = Ptry * PI(i)^GAMtry(i)*(1-PI(i))^(1-GAMtry(i));
    probSTAR = Pstar * PI(i)^GAMstar(i)*(1-PI(i))^(1-GAMstar(i));
    
    if probTRY==0 && probSTAR==0  %b/c computational problems with precision
        if GAMtry(i)==0                 %-> favour more sparse GAM
            GAMstar(i) = GAMtry(i);     %else: GAMstar(i) = GAM(i)
            Pstar = Ptry;           
        end
    else
        U = rand;
        if U <= probTRY/(probSTAR + probTRY)
            GAMstar(i) = GAMtry(i);     %else: GAMstar(i) = GAM(i)
            Pstar = Ptry;   %else: Pstar stays the same
        end
    end
end

%(2) compute values corresponding to proposed GAMstar
Xstar = X(:,logical(GAMstar));
vstar = v(logical(GAMstar),logical(GAMstar));
if sum(GAMstar) > n
    %inversion of nxn matrix:
    Vstar = vstar - vstar*Xstar'*inv(LAM + Xstar*vstar*Xstar')*Xstar*vstar;
else
    %inversion of dxd matrix (d=dim(GAM)):
    Vstar = inv(Xstar'*invLAM*Xstar + inv(vstar));  
end
Bstar = Vstar*Xstar'*invLAM*Z;
    
%(3) acceptance/rejection step is not needed since alpha = 1 always
GAM = GAMstar;
Vgam = Vstar;
Bgam = Bstar;
Xgam = Xstar;
vgam = vstar;

Zprec = invLAM - invLAM*Xgam*Vgam*Xgam'*invLAM;
detZprec = det(Zprec);
%logPgam = log(sqrt(detZprec)) - 0.5*(Z'*Zprec*Z); %log(MVN(0,inv(Zprec)))
logPgam = normpdfln(Z, zeros(size(Z)), 'inv', Zprec);

T = randn(sum(GAM),1);
L = chol(Vgam)';   %lower triangular Cholesky factorisation matrix
beta = Bgam + L*T;

% log probabilities log(P(beta,GAM|Z,LAM)) and log(P(beta,GAM))
logpriorGAM = sum(log(PI).*GAM + log(1-PI).*(1-GAM));
logpostGAM = logPgam + logpriorGAM;
if numel(beta) > 0
    logpostbeta = normpdfln(beta, Bgam, [], Vgam);
    logpriorbeta = normpdfln(beta, zeros(size(beta)), [], vgam);
else
    logpostbeta = 0;    %P(beta=empty|GAM,Z,LAM) = 1 (since GAM=zeros(p))
    logpriorbeta = 0;
end
logprior = logpriorGAM + logpriorbeta;
%logpost = logpostGAM + logpostbeta;
logpost = logPgam + logpostbeta;    %logpriorGAM cancels out anyway

%Manuela Zucknick, last update: 02-06-07