function [beta,GAM,numneigh,logprior,logpost] = ...
    betaGAM_update_blockJoint(LAM,Z,X,v,PI,GAM,block,K1,temp)
% BETAGAM_UPDATE_BLOCKJOINT joint block update for LAM and Z in Bayesian 
% auxiliary variable model for logistic regression with variable selection
% Help function for LOGISTICVS
%
% Selects a variable at random and updates it plus up to (K1-1) neighbours
% together from their joint conditional distribution

if (nargin < 9)
    temp = 1;
end

n = size(X,1);
p = size(X,2);

%Here, temperature temp only comes in as a multiplier for LAM in the 
%(tempered) density p(Z|LAM,beta,Xgam)* = N(Xgam*beta, LAM*temp):
LAM = LAM*temp; 
invLAM = diag(1./diag(LAM));

%(1) Find variables to update together with GAM(select) (= block)
select = randperm(p);
select = select(1);

neighbour = find(block(select,:));   %1st order nb.

%select up to (K1-1) first-order neighbours of select
numneigh = numel(neighbour);
selectneigh = randperm(numneigh);
selectneigh = neighbour(selectneigh);
maxneigh = min((K1-1), numneigh);
selectneigh = selectneigh(1:maxneigh);
neighbour = unique([select, selectneigh]);
numneigh = numel(neighbour);    %K1 or smaller

GAMtry = kron(ones(1,2^numneigh), GAM); 
    %each column of matrix GAMtry represents one possible combination 
    %of values for the genes in neighbour (for now all are equal to GAM)

for i = 1:numneigh
    %every possible combination of neighbour genes being in/out of model:
    num = 2^(numneigh-i);
    ind = kron(ones(1,2^(i-1)), [ones(1,num),zeros(1,num)]);
    GAMtry(neighbour(i),:) = ind;
end

%(2) Cycle through all combinations of values for neighbours and compute
%posterior probability of the corresponding GAM value
numcomb = size(GAMtry,2);
probTRY = zeros(1,numcomb);
for i = 1:numcomb    
    GAMi = GAMtry(:,i);
    Xtry = X(:,logical(GAMi));
    vtry = v(logical(GAMi),logical(GAMi));
    if sum(GAMi) > n
        %inversion of nxn matrix:
        Vtry = vtry - vtry*Xtry'*inv(LAM + Xtry*vtry*Xtry')*Xtry*vtry;
    else
        %inversion of dxd matrix (d=dim(GAMtry)):
        Vtry = inv(Xtry'*invLAM*Xtry + inv(vtry));  
    end
    Zprectry = invLAM - invLAM*Xtry*Vtry*Xtry'*invLAM;
    detZprectry = det(Zprectry);
    Ptry = sqrt(detZprectry)*exp(-0.5*(Z'*Zprectry*Z)); 
        %p(Z|GAM)=MVN(0,inv(Zprec))
    
    probTRY(i) = Ptry .* prod(PI(neighbour).^GAMi(neighbour) .* ...
                         (1-PI(neighbour)).^(1-GAMi(neighbour)));
end

%(3) Sample new GAM according to probTRY and compute corresponding values
probTRY = probTRY./sum(probTRY);    %normalise to sum=1
%inversion method for sampling from discrete distribution
%(alias-urn method would be faster)
U = rand;
I = find(U < cumsum(probTRY));
GAM = GAMtry(:,min(I));

Xgam = X(:,logical(GAM));
vgam = v(logical(GAM),logical(GAM));
if sum(GAM) > n
    %inversion of nxn matrix:
    Vgam = vgam - vgam*Xgam'*inv(LAM + Xgam*vgam*Xgam')*Xgam*vgam;
else
    %inversion of dxd matrix (d=dim(GAM)):
    Vgam = inv(Xgam'*invLAM*Xgam + inv(vgam));  
end
Zprec = invLAM - invLAM*Xgam*Vgam*Xgam'*invLAM;
detZprec = det(Zprec);
%logPgam = log(sqrt(detZprec)) - 0.5*(Z'*Zprec*Z); %log(MVN(0,inv(Zprec)))
logPgam = normpdfln(Z, zeros(size(Z)), 'inv', Zprec);
Bgam = Vgam*Xgam'*invLAM*Z;
    
T = randn(sum(GAM),1);
L = chol(Vgam)';   %lower triangular Cholesky factorisation matrix
beta = Bgam + L*T;

% log probabilities log(P(beta,GAM|Z,LAM)) and log(P(beta,GAM))
logpriorGAM = sum(log(PI).*GAM + log(1-PI).*(1-GAM));
logpostGAM = logPgam + logpriorGAM;
if numel(beta) > 0
    logpostbeta = normpdfln(beta, Bgam, [], Vgam);
    logpriorbeta = normpdfln(beta, zeros(size(beta)), [], vgam);
else
    logpostbeta = 0;    %P(beta=empty|GAM,Z,LAM) = 1 (since GAM=zeros(p))
    logpriorbeta = 0;
end
logprior = logpriorGAM + logpriorbeta;
%logpost = logpostGAM + logpostbeta;
logpost = logPgam + logpostbeta;    %logpriorGAM cancels out anyway

% last update: 02-03-07