function [LAM,Z, logprob,R] = LAMz_update(beta,GAM, X,Y, T)
% LAMZ_UPDATE Gibbs sampling update for LAM and Z in Bayesian auxiliary 
% variable model for logistic regression with variable selection
% Help function for LOGISTICVS

if (nargin < 5)
    T = 1;
end

n = size(Y,1);
Z = zeros(n,1);
LAM = eye(n);
R = zeros(n,1);
Xgam = X(:,logical(GAM));
logZ = 0;
logpriorLAM = 0;
logLAM = 0;
for j = 1:n
    m = Xgam(j,:)*beta;
    if Y(j) > 0 
        Z(j) = lefttrunclogis(m,sqrt(T),0);
    else
        Z(j) = righttrunclogis(m,sqrt(T),0);
    end
    R(j) = Z(j) - m;
    LAM(j,j) = lambdadist_temp(abs(R(j)),T);
    
    logpriorLAM = logpriorLAM - 0.5*log(16*LAM(j,j)) ...
                + log(KS_pdf(0.5*sqrt(LAM(j,j))));
end
logZ = normpdfln(Z, Xgam*beta, T*LAM);
logprob = logZ + logpriorLAM;

% Manuela Zucknick, 15-04-05, last update: 08-03-07