function pdf = KS_pdf(x)
% PURPOSE: computes the Kolmogorov-Smirnov density for x
%---------------------------------------------------
% USAGE: pdf = KS_pdf(x, iter)
% where: x = variable vector (nx1), iter = scalar (number of terms in - 
% infinite - sum to be evaluated) 
%---------------------------------------------------
% RETURNS: pdf == (nx1) vector containing pdf for each x
%---------------------------------------------------
% Reference: Devroye (1986) "Non-uniform random variate generation", p.161

  if (nargin ~= 1)
      error('Wrong # of arguments to KS_pdf');
  end;
  
  [r, c] = size(x);
  s = r * c;
  x = reshape(x, 1, s);
  pdf = zeros(1, s);
  
  k = find (isnan(x));
  if any (k)
    pdf(k) = NaN * ones(1, length(k));
  end;
  
  k = find (~isinf(x));
  if any (k)
    pdf_tmp = x(k) .* exp(-2 * x(k).^2);
    n = 1;
    while any(abs(pdf_tmp) > eps)
        pdf(k) = pdf(k) + pdf_tmp;
        n = n + 1;
        n2 = n^2;
        pdf_tmp = (-1)^(n+1) * n2 * x(k) .* exp(-2 * n2 * x(k).^2);
    end
  end;
  
  pdf = 8 * pdf;
  pdf = reshape(pdf, r, c);
  
% Manuela Zucknick (manuela.zucknick@imperial.ac.uk), 03-08-2006
  
