### Name: simulation.indep
### Title: Simulation for independent experiments
### Aliases: simulation.indep
### Keywords: misc

### ** Examples

data.indep = simulation(n=500,GammaA=1,GammaB=1,r1=0.5,r2=0.8,DEfirst=300,DEsecond=200,DEcommon=100)
## The function is currently defined as
function(n,GammaA=2,GammaB=2,epsilonM=0, epsilonSD=1, r1,r2,DEfirst,DEsecond){

T1=c()
T2=c()
delta=rgamma(n,shape=GammaA,scale=GammaB)
epsilon1=rnorm(n,epsilonM,epsilonSD)
epsilon2=rnorm(n,epsilonM,epsilonSD)
names=c()
#Group 1 : DE in the first experiment
for(i in (1):(DEfirst)){
    x=rbinom(1,1,0.5)
    if(x==1){T1[i] <- delta[i] + epsilon1[i]*r1}
    if(x==0){T1[i] <- -delta[i] - epsilon1[i]*r1}
    T2[i] <- epsilon2[i]*r2
    names[i] <- "DEfirst"
}

#Group 2 : DE in the second experiment
for(i in (DEfirst+1):(DEfirst+DEsecond)){
    x=rbinom(1,1,0.5)
    T1[i] <- epsilon1[i]*r1
    if(x==1){T2[i] <- delta[i] + epsilon2[i]*r2}
    if(x==0){T2[i] <- -delta[i] - epsilon2[i]*r2}
    names[i] <- "DEsecond"

}

#Group 3 : Not DE in Both experiments
for(i in (DEfirst+DEsecond+1):(n)){
    T1[i] <- epsilon1[i]*r1
    T2[i] <- epsilon2[i]*r2
    names[i] <- "Null"
}

##############################################
#Assign the Pvalues

Pval1 = c()
Pval2 = c()

for(i in 1:n){
Pval1[i] <- 2*pnorm(-abs(T1[i]/r1))
Pval2[i] <- 2*pnorm(-abs(T2[i]/r2))
}

##############################################
return(list(names=names,T1=T1,T2=T2,Pval=cbind(Pval1,Pval2)))
        }



