### Name: extractGenes
### Title: Function for extracting the lists of genes in common
### Aliases: extractGenes
### Keywords: misc

### ** Examples

data = simulation(n=500,GammaA=1,GammaB=1,r1=0.5,r2=0.8,DEfirst=300,DEsecond=200,DEcommon=100)
T<- ratio(data$Pval,interval=0.01,dir="D:/",name="CompData1Data2",pvalue=TRUE)
BayesianModel<- baymod(data$Pval,repl=100,output.ratio=T,dir="D:/")
gene.names = data$names
gene.lists <- extractGenes(output.ratio=T,output.bay=BayesianModel,gene.names,data$Pval,q=NULL)

## The function is currently defined as
function(output.ratio,output.bay,gene.names,data,q=NULL){
if(output.ratio$pvalue==FALSE){
data = 1 - data
}

lists = dim(data)[2]
#Decision rules:
#1) Maximum for CI not including 1
max.R = max(output.bay[round(round(output.bay[,1],2),1)>1,2])
threshold.max = output.ratio$q[output.bay[,2]==max.R]

#Table
temp = matrix(0,dim(data)[1],lists)
for(i in 1:dim(data)[1]){
                for(j in 1:lists){
                        if(data[i,j]<= threshold.max){temp[i,j]<-1}
                }
}

table.max <- data[apply(temp,1,sum)==lists,]
names.max <- gene.names[apply(temp,1,sum)==lists]

if(output.ratio$pvalue==FALSE){
table.max <- data.frame(Names=names.max,RankingStat = 1- table.max)
}

if(output.ratio$pvalue==TRUE){
table.max <- data.frame(Names=names.max,RankingStat = table.max)
}

if(length(output.ratio$q[output.bay[round(output.bay[,1],2)>1,2]>=2])>0){

#2) Rule 2
threshold.2 = max(output.ratio$q[round(round(output.bay[,2],2),3)>=2 & round(round(output.bay[,1],2),1)>1])

#Table
temp = matrix(0,dim(data)[1],lists)
for(i in 1:dim(data)[1]){
                for(j in 1:lists){
                        if(data[i,j]<= threshold.2){temp[i,j]<-1}
                }
}

table.2 <- data[apply(temp,1,sum)==lists,]
names.2 <- gene.names[apply(temp,1,sum)==lists]

if(output.ratio$pvalue==FALSE){
table.2 <- data.frame(Names=names.2,RankingStat = 1-table.2)
}

if(output.ratio$pvalue==TRUE){
table.2 <- data.frame(Names=names.2,RankingStat = table.2)
        }

if(is.null(q))
{return(list(max = table.max,rule2 = table.2))}

if(!is.null(q)){
l = length(q)
table.q = list()
        for(r in 1:l){

temp = matrix(0,dim(data)[1],lists)
for(i in 1:dim(data)[1]){
                for(j in 1:lists){
                        if(data[i,j]<= q[r]){temp[i,j]<-1}
                                }
                        }

table.q[[r]] <- data[apply(temp,1,sum)==lists,]
names.q <- gene.names[apply(temp,1,sum)==lists]
if(output.ratio$pvalue==FALSE){
        table.q[[r]] <- data.frame(Names=names.q,RankingStat = 1-table.q[[r]])
        }

if(output.ratio$pvalue==TRUE){
        table.q[[r]] <- data.frame(Names=names.q,RankingStat = table.q[[r]])
        }

names(table.q)[[r]] <- paste("q=",q[r]) 
                        }
                }
return(list(max = table.max,rule2 = table.2, User = table.q))
        }

if(length(output.ratio$q[output.bay[round(output.bay[,1],2)>1,2]>=2])==0){

if(is.null(q))
{return(list(max = table.max))}

if(!is.null(q)){
l = length(q)
table.q = list()
        for(r in 1:l){

temp = matrix(0,dim(data)[1],lists)
for(i in 1:dim(data)[1]){
                for(j in 1:lists){
                        if(data[i,j]<= q[r]){temp[i,j]<-1}
                                }
                        }

table.q[[r]] <- data[apply(temp,1,sum)==lists,]
names.q <- gene.names[apply(temp,1,sum)==lists]
if(output.ratio$pvalue==FALSE){
        table.q[[r]] <- data.frame(Names=names.q,RankingStat = 1-table.q[[r]])
        }

if(output.ratio$pvalue==TRUE){
        table.q[[r]] <- data.frame(Names=names.q,RankingStat = table.q[[r]])
        }

names(table.q)[[r]] <- paste("q=",q[r]) 
                                }
                        }
return(list(max = table.max,User = table.q))
        }

}




