### Name: createTable
### Title: Function to create an output table
### Aliases: createTable
### Keywords: misc

### ** Examples

data = simulation(n=500,GammaA=1,GammaB=1,r1=0.5,r2=0.8,DEfirst=300,DEsecond=200,DEcommon=100)
T<- ratio(data$Pval,interval=0.01,dir="D:/",name="CompData1Data2",pvalue=TRUE)
BayesianModel<- baymod(data$Pval,repl=100,output.ratio=T,dir="D:/")
output.table <- createTable(dir="D:/",output.ratio=T,output.bay=BayesianModel,name="OutputTable")
 
## The function is currently defined as
function(dir,output.ratio,output.bay,name){
if(output.ratio$pvalue==TRUE){
matrix.results =  cbind(output.ratio$q,round(output.bay,3),output.ratio$DECommon,output.ratio$DE)
lists = dim(output.ratio$DE)[2]
namesDE = paste("O",seq(1,lists),rep("+",lists))
names.matrix = c("q","LowCI","MedCI","HighCI","O11",namesDE)
dimnames(matrix.results)[[2]]<-names.matrix
}
if(output.ratio$pvalue==FALSE){
matrix.results =  cbind(1-output.ratio$q,round(output.bay,3),output.ratio$DECommon,output.ratio$DE)
lists = dim(output.ratio$DE)[2]
namesDE = paste("O",seq(1,lists),rep("+",lists))
names.matrix = c("q","LowCI","MedCI","HighCI","O11",namesDE)
dimnames(matrix.results)[[2]]<-names.matrix
}

#Decision rules:
#1) Maximum for CI not including 1
max.R = max(matrix.results[round(round(matrix.results[,2],2),1)>1,3])
maximum = matrix.results[matrix.results[,3]==max.R,]

if(length(matrix.results[matrix.results[round(matrix.results[,2],2)>1,3]>=2,1])>0){
#2) Rule 2
R2 = max(matrix.results[round(round(matrix.results[,3],2),3)>=2 & round(round(matrix.results[,2],2),1)>1 ,1])
rule2 = matrix.results[matrix.results[,1]==R2,]

setwd(dir)
write.csv(matrix.results,paste(name,".csv"),row.names=FALSE)
return(list(maximum=maximum,rule2=rule2))
        }

if(length(matrix.results[matrix.results[round(matrix.results[,2],2)>1,3]>=2,1])==0){
#2) Rule 2
setwd(dir)
write.csv(matrix.results,paste(name,".csv"),row.names=FALSE)
return(maximum=maximum)
        }

}




